/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.data;

import com.google.common.collect.Lists;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.ftb.data.ModPack;
import net.ftb.data.events.TexturePackListener;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.panes.TexturepackPane;
import net.ftb.log.Logger;
import net.ftb.util.DownloadUtils;
import net.ftb.util.OSUtils;
import net.ftb.workers.TexturePackLoader;

public class TexturePack {
    private String name;
    private String author;
    private String version;
    private String url;
    private String mcversion;
    private String logoName;
    private String imageName;
    private String info;
    private String resolution;
    private String sep = File.separator;
    private Image logo;
    private Image image;
    private List<String> compatible = Lists.newArrayList();
    private List<String> masters = Lists.newArrayList();
    private int index;
    private static final ArrayList<TexturePack> texturePackArray = Lists.newArrayList();
    private static List<TexturePackListener> listeners = Lists.newArrayList();

    public static void addListener(TexturePackListener listener) {
        listeners.add(listener);
    }

    public static void loadAll() {
        TexturePackLoader loader = new TexturePackLoader();
        loader.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTexturePack(TexturePack texturePack) {
        ArrayList<TexturePack> arrayList = texturePackArray;
        synchronized (arrayList) {
            texturePackArray.add(texturePack);
        }
        for (TexturePackListener listener : listeners) {
            listener.onTexturePackAdded(texturePack);
        }
    }

    public static TexturePack getTexturePack(int i) {
        return texturePackArray.get(i);
    }

    public static TexturePack getSelectedTexturePack() {
        return TexturePack.getTexturePack(TexturepackPane.getSelectedTexturePackIndex());
    }

    public TexturePack(String name, String author, String version, String url, String logo, String image, String mcversion, String compatible, String info, String resolution, int idx) throws NoSuchAlgorithmException, IOException {
        this.index = idx;
        this.name = name;
        this.author = author;
        this.version = version;
        this.url = url;
        this.version = version;
        String installPath = OSUtils.getCacheStorageLocation();
        this.logoName = logo;
        this.imageName = image;
        String[] tmp = compatible.split(",");
        Collections.addAll(this.compatible, tmp);
        this.info = info;
        this.resolution = resolution;
        Iterator<Object> it = this.compatible.iterator();
        while (it.hasNext()) {
            String s = it.next();
            if (!s.toLowerCase().startsWith("master")) continue;
            this.masters.add(s.replace("master_", ""));
            it.remove();
        }
        for (ModPack p : ModPack.getPackArray()) {
            if (p.hasCustomTP() || this.compatible.contains(p.getDir()) || !this.masters.contains(p.getMcVersion().replace(".", "_"))) continue;
            this.compatible.add(p.getDir());
        }
        File tempDir = new File(installPath, "TexturePacks" + this.sep + name);
        File verFile = new File(tempDir, "version");
        if (!this.upToDate(verFile)) {
            DownloadUtils.saveImage(logo, tempDir, "png");
            DownloadUtils.saveImage(image, tempDir, "png");
        } else {
            if (!new File(tempDir, logo).exists()) {
                DownloadUtils.saveImage(logo, tempDir, "png");
            }
            if (!new File(tempDir, image).exists()) {
                DownloadUtils.saveImage(image, tempDir, "png");
            }
        }
        if (!new File(tempDir, logo).exists()) {
            logo = "logo_ftb.png";
            this.logoName = "logo_ftb.png";
            DownloadUtils.saveImage(logo, tempDir, "png");
        }
        this.logo = Toolkit.getDefaultToolkit().createImage(tempDir.getPath() + this.sep + logo);
        if (!new File(tempDir, image).exists()) {
            image = "default_splash.png";
            this.imageName = "default_splash.png";
            DownloadUtils.saveImage(image, tempDir, "png");
        }
        this.image = Toolkit.getDefaultToolkit().createImage(tempDir.getPath() + this.sep + image);
    }

    private boolean upToDate(File verFile) {
        boolean result = true;
        try {
            if (!verFile.exists()) {
                verFile.getParentFile().mkdirs();
                verFile.createNewFile();
                result = false;
            }
            BufferedReader in = new BufferedReader(new FileReader(verFile));
            String line = in.readLine();
            int storedVersion = -1;
            if (line != null) {
                try {
                    storedVersion = Integer.parseInt(line.replace(".", ""));
                }
                catch (NumberFormatException e) {
                    Logger.logWarn("Automatically fixing malformed version file for " + this.name, e);
                    line = null;
                }
            }
            if (line == null || Integer.parseInt(this.version.replace(".", "")) != storedVersion) {
                BufferedWriter out = new BufferedWriter(new FileWriter(verFile));
                out.write(this.version);
                out.flush();
                out.close();
                result = false;
            }
            in.close();
        }
        catch (IOException e) {
            Logger.logError("Error while checking texturepack version", e);
        }
        return result;
    }

    public String getSelectedCompatible() {
        return this.compatible.get(LaunchFrame.getSelectedTPInstallIndex()).trim();
    }

    public boolean isCompatible(String packName) {
        for (String aCompatible : this.compatible) {
            ModPack pack = ModPack.getPack(aCompatible);
            if (pack == null) {
                Logger.logDebug("Texturepack is compatible with " + packName + " , but modpack not found");
                continue;
            }
            return pack.getName().equals(packName);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMcversion() {
        return this.mcversion;
    }

    public String getLogoName() {
        return this.logoName;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getInfo() {
        return this.info;
    }

    public String getResolution() {
        return this.resolution;
    }

    public Image getLogo() {
        return this.logo;
    }

    public Image getImage() {
        return this.image;
    }

    public List<String> getCompatible() {
        return this.compatible;
    }

    public List<String> getMasters() {
        return this.masters;
    }

    public int getIndex() {
        return this.index;
    }

    public static ArrayList<TexturePack> getTexturePackArray() {
        return texturePackArray;
    }
}

